/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.config;

import net.minecraftforge.common.ForgeConfigSpec;

public final class MutantShulkerTrapCommonConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Double> mutant_shulker_damage;
    public static final ForgeConfigSpec.ConfigValue<Double> player_damage;
    public static final ForgeConfigSpec.ConfigValue<Boolean> mutant_shulker_multiuse;
    public static final ForgeConfigSpec.ConfigValue<Boolean> player_multiuse;
    public static final ForgeConfigSpec.ConfigValue<Boolean> turns_to_bullet;
    public static final ForgeConfigSpec.ConfigValue<Integer> turn_to_bullet_time;
    public static final ForgeConfigSpec.ConfigValue<Integer> slowness_length;
    public static final ForgeConfigSpec.ConfigValue<Integer> slowness_level;
    public static final ForgeConfigSpec.ConfigValue<Double> thorns_damage;
    public static final ForgeConfigSpec.ConfigValue<Double> max_health;
    public static final ForgeConfigSpec.ConfigValue<Double> armour;
    public static final ForgeConfigSpec.ConfigValue<Double> armour_toughness;
    public static final ForgeConfigSpec.ConfigValue<Double> knockback_resistance;
    public static final ForgeConfigSpec.ConfigValue<Double> shulker_bullet_damage;
    public static final ForgeConfigSpec.ConfigValue<Integer> shulker_bullet_levitation_length;
    public static final ForgeConfigSpec.ConfigValue<Integer> shulker_bullet_levitation_level;

    static {
        BUILDER.comment("Configure Mutant More's Wither Bomb on the client and server sides (these changes will affect everyone in the world)! The game needs to be restarted for changes to take effect!");
        mutant_shulker_damage = BUILDER.comment("\n The damage dealt to mobs snapped by Mutant Shulker Traps that were spawned by the Mutant Shulker\n usually set to 10.0").define("Mutant Shulker Damage", (Object)10.0);
        player_damage = BUILDER.comment("\n The damage dealt to mobs snapped by Mutant Shulker Traps that were placed by a Player\n usually set to 10.0").define("Player Damage", (Object)10.0);
        mutant_shulker_multiuse = BUILDER.comment("\n If Mutant Shulker Traps spawned by the Mutant Shulker can snap mobs permanently instead of only one time\n usually set to false").define("Mutant Shulker Multi-Use", false);
        player_multiuse = BUILDER.comment("\n If Mutant Shulker Traps placed by a Player can snap mobs permanently instead of only one time\n usually set to true").define("Player Multi-Use", true);
        turns_to_bullet = BUILDER.comment("\n If Mutant Shulker Traps spawned by the Mutant Shulker transform into Shulker bullets after a certain amount of time\n usually set to true").define("Turns to Bullet", true);
        turn_to_bullet_time = BUILDER.comment("\n The amount of time in ticks (20 ticks in a second) before a Mutant Shulker Bullet spawned by the Mutant Shulker transforms into a Shulker Bullet\n usually set to 300 ticks (15 seconds)").define("Turn to Bullet Time", (Object)300);
        slowness_length = BUILDER.comment("\n The amount of time in ticks (20 ticks in a second) that a Mutant Shulker Trap applies the Slowness effect to a mob for after snapping them\n usually set to 80 ticks (4 seconds)").define("Slowness Length", (Object)80);
        slowness_level = BUILDER.comment("\n The level of the Slowness effect applied to mobs when snapped by a Mutant Shulker Trap\n usually set to 1 (Slowness 2)").define("Slowness Level", (Object)1);
        thorns_damage = BUILDER.comment("\n The thorns damage dealt to mobs that harm the Mutant Shulker Trap\n usually set to 4.0").define("Thorns Damage", (Object)4.0);
        max_health = BUILDER.comment("\n The Mutant Shulker Trap's max health\n usually set to 5.0").define("Max Health", (Object)5.0);
        armour = BUILDER.comment("\n The Mutant Shulker Trap's armour value\n usually set to 5.0").define("Armour", (Object)5.0);
        armour_toughness = BUILDER.comment("\n The Mutant Shulker Trap's armour toughness value\n usually set to 0.0").define("Armour Toughness", (Object)0.0);
        knockback_resistance = BUILDER.comment("\n The Mutant Shulker Trap's resistance to attack knockback\n usually set to 1.0 (no knockback)").define("Knockback Resistance", (Object)1.0);
        shulker_bullet_damage = BUILDER.comment("\n The damage dealt to mobs hit by a Shulker Bullet that a Mutant Shulker Trap transformed into\n usually set to 2.0").define("Shulker Bullet Damage", (Object)8.0);
        shulker_bullet_levitation_length = BUILDER.comment("\n The length in ticks (20 ticks in a second) that the Levitation effect is applied to mobs hit by Shulker Bullets that Mutant Shulker Traps transformed into\n usually set to 100 ticks (5 seconds)").define("Shulker Bullet Levitation Length", (Object)100);
        shulker_bullet_levitation_level = BUILDER.comment("\n The level of the Levitation effect applied to mobs hit by Shulker Bullets that Mutant Shulker Traps transformed into\n usually set to 0 (Levitation 1)").define("Shulker Bullet Levitation Level", (Object)0);
        SPEC = BUILDER.build();
    }
}

